import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:razinsoft_rider/core/extensions/extensions.dart';
import 'package:razinsoft_rider/core/utils/network_image.dart';
import 'package:razinsoft_rider/data/models/ride_service_response.dart';

import '../../../core/theme/color_palette.dart';
import '../viewmodel/car_type_notifier.dart';

Widget buildCarCard(Services type, bool isSelected,
    CarTypeNotifier notifier, BuildContext context, {Function()? onTap}) => GestureDetector(
    onTap: onTap,
    child: AnimatedContainer(
      width: 114,
      duration: const Duration(milliseconds: 200),
      margin: const EdgeInsets.only(right: 8),
      padding: const EdgeInsets.symmetric(vertical: 8, horizontal: 12),
      decoration: BoxDecoration(
        color: ColorPalette.primary50.withValues(alpha: 0.13),
        borderRadius: BorderRadius.circular(8),
        border: Border.all(
          color: isSelected ? ColorPalette.primary50 : Colors.transparent,
        ),
      ),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          Expanded(child: buildNetworkImage(imageUrl: type.logo, height: 60, width: 60, fit: BoxFit.contain)),
          Text(
            type.name ?? '',
            overflow: TextOverflow.ellipsis,
            maxLines: 1,
            style: context.bodyMedium?.copyWith(fontSize: 16.sp, fontWeight: FontWeight.w600),
            textAlign: TextAlign.center,
          ),
        ],
      ),
    ),
  );